#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(t--) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

struct edge {
	int from, to;
	int id;
	edge():from(-1), to(-1),id(-1){}
	edge(int from, int to, int id):from(from),to(to),id(id) {}
};

int n, m;
vector <vector <edge> > g;
vector <edge> allEdges;
vector <int> goodEdges;
//vector <int> bridges;

int TIMER = 0;
vector <int> tin;
//vector <int> tout;
vector <int> fup;

int USEDTIMER = 1;
vector <int> used;

void dfs(int v, vector <int>& bridges, const edge& par = edge()) {
	used[v] = USEDTIMER;

	++TIMER;
	fup[v] = tin[v] = TIMER;

	for (int i = 0; i < g[v].size(); ++i) {
		if (!goodEdges[g[v][i].id]) {
			continue;
		}

		if (g[v][i].id == par.id) {
			continue;
		}

		if (used[g[v][i].to] != USEDTIMER) {
			dfs(g[v][i].to, bridges, g[v][i]);
			fup[v] = min(fup[g[v][i].to], fup[v]);
		}
		else {
			fup[v] = min(fup[v], tin[g[v][i].to]);
		}
	}

	if (par.from != -1 && fup[v] > tin[par.from]) {
		bridges.push_back(par.id);
	}

	//++TIMER;
	//tout[v] = TIMER;
}

void getTree(int v, vector <int>& tree) {
	used[v] = USEDTIMER;

	for (int i  =0; i < g[v].size(); ++i) {
		if (!goodEdges[g[v][i].id]) {
			continue;
		}
		if (used[g[v][i].to] == USEDTIMER) {
			continue;
		}
		tree.push_back(g[v][i].id);
		getTree(g[v][i].to, tree);
	}
}

vector <int> inTree;

int TREEI;
int ansR;

void dfsFuck(int v, const edge& par = edge()) {
	used[v] = USEDTIMER;

	++TIMER;
	fup[v] = tin[v] = TIMER;

	for (int i = 0; i < g[v].size(); ++i) {
		if (!goodEdges[g[v][i].id]) {
			continue;
		}

		if (g[v][i].id == par.id) {
			continue;
		}

		if (used[g[v][i].to] != USEDTIMER) {
			dfsFuck(g[v][i].to, g[v][i]);
			fup[v] = min(fup[g[v][i].to], fup[v]);
		}
		else {
			fup[v] = min(fup[v], tin[g[v][i].to]);
		}
	}


	if (par.from != -1 && fup[v] > tin[par.from]) {
		if ((!inTree[par.id]) || (inTree[par.id] && par.id > TREEI)) {
			++ansR;
		}
	}

	//++TIMER;
	//tout[v] = TIMER;
}

int solve(int v) {
	++USEDTIMER;
	
	vector <int> tree;
	getTree(v, tree);

	for (int i = 0; i < tree.size(); ++i) {
		inTree[tree[i]] = 1;	
	}

	ansR = 0;

	for (int i = 0; i < tree.size(); ++i) {
		++USEDTIMER;
		goodEdges[tree[i]] = 0;

		TREEI = tree[i];
		dfsFuck(v);

		/*
		for (int j = 0; j < bridges.size(); ++j) {
			if ((!inTree[bridges[j]]) || (inTree[bridges[j]] && bridges[j] > tree[i])) {
				++ans;
			}
		}
		*/
		goodEdges[tree[i]] = 1;
	}


	return ansR;
}

void solve() {
	cin >> n >> m;
	inTree.resize(m, 0);
	g.resize(n);
	allEdges.resize(m);
	goodEdges.assign(m, 1);
	
	tin.assign(n, -1);
	fup.resize(n);
	
	for (int i = 0; i < m; ++i) {
		int x, y, w;
		cin >> x >> y;
		--x;
		--y;
		allEdges[i] = edge(x, y, i);
		g[x].push_back(edge(x, y, i));
		g[y].push_back(edge(y, x, i));
	}
	used.resize(n);

	++USEDTIMER;
	vector <int> allBridges;
	dfs(0, allBridges);

	li ans = (li)allBridges.size() * ((li)allBridges.size() - 1) / 2;
	ans += li(m - allBridges.size()) * allBridges.size();
	
	for (int i = 0; i < allBridges.size(); ++i) {
		goodEdges[allBridges[i]] = 0;	
	}

	++USEDTIMER;
	int tmpp = USEDTIMER;

	for (int i = 0; i < n; ++i) {
		if (used[i] < tmpp) {
			ans += solve(i);		
		}
	}

	cout << ans << endl;
}